# Abstract

As an effective tool for eliciting the power of Large Language Models (LLMs), prompting has recently demonstrated unprecedented abilities across a variety of complex tasks. To further improve the performance, prompt ensemble has attracted substantial interest for tackling the hallucination and instability of LLMs. However, existing methods usually adopt a two-stage paradigm, which requires a pre-prepared set of prompts with substantial manual effort, and is unable to perform directed optimization for different weak learners. In this paper, we propose a simple, universal, and automatic method named PREFER (**PR**ompt **E**nsemble learning via **F**eedback-R**E**flect-**R**efine) to address the stated limitations. Specifically, given the fact that weak learners are supposed to focus on hard examples during boosting, PREFER builds a feedback mechanism for reflecting on the inadequacies of existing weak learners. Based on this, the LLM is required to automatically synthesize new prompts for iterative refinement. Moreover, to enhance stability of the prompt effect evaluation, we propose a novel prompt bagging method involving forward and backward thinking, which is superior to majority voting and is beneficial for both feedback and weight calculation in boosting. Extensive experiments demonstrate that our PREFER achieves state-of-the-art performance in multiple types of tasks by a significant margin.

# Introduction

Large Language Models (LLMs) have recently flourished across a variety of fields, demonstrating unprecedented abilities in myriad of complex tasks [zhao2023survey; ouyang2022training]. Trained with large-scale web data on massive parameters, LLMs show emergent abilities beyond the original linguistic competence [wei2022emergent], which perform tremendous versatility in both academia and industry. To elicit the power of pretrained LLMs directly or adapt LLMs to specific domains, various paradigms are proposed, including prompt engineering [qiao2022reasoning], p-tuning [liu2021gpt], and LoRA finetuning [hu2021lora], etc. Due to the immense scale of the model parameters, finetuning on all or even part of LLMs is costly and time-consuming. To this end, as a simple and effective paradigm, prompt engineering explores a fundamentally new way of invoking intrinsic knowledge and reasoning ability of LLMs based on a pretrain-prompt-predict manner [liu2023pre].

[IMAGE: High-level overview of feedback-reflect-refine paradigm. p_t denotes the prompt at the t-th iteration.]

Though promising, the naive prompting approaches are afflicted by several limitations. As generative language models, LLMs' output commonly has a large variance. For instance, the reasoning logic and predicted results could be contradictory in multiple runs, although the input prompts are fixed. In addition, LLMs suffer from the notoriously hallucination issue [ji2023survey], leading to results that are plausible-sounding but factually incorrect or irrelevant to the inputs. Furthermore, the quality of LLMs' output is susceptible to the given prompts, which entails substantial manual effort and domain expertise to find out the reliable prompts.

As a promising solution to these issues, prompt ensemble learning has attracted substantial interest in the community very recently, demonstrating significant improvements in both effectiveness and stability across various tasks. As a representative work, PromptBoosting [hou2023promptboosting] applies the traditional AdaBoost [freund1997decision] algorithm over a set of pre-defined prompts for text classification. BPE [pitis2023boosted] focuses on Chain-of-Thought (CoT) [wei2022chain] boosting and builds few-shot CoT prompts based on self-consistency [wang2022self]. These efforts empirically demonstrate the strength of prompt ensembles for LLM-based tasks, yielding exceptional performance gains over single-prompt baselines.

However, despite their success, existing prompt ensemble approaches, which typically adopt a two-stage process, have several limitations. First, they require a pre-prepared set of prompts in advance, which are either manually defined or generated by another language model with heavy parameters. This preliminary work is costly and laborious, often involving a trial-and-error or pre-evaluation process to ensure the quality of pre-defined prompts. Second, the two-stage paradigm fixes the prompts to be used in the ensemble process, limiting the adaptability and scalability of prompt boosting, as the prompts cannot be optimized jointly. Since the relationships between prompts are ignored during the iterative boosting process, the pre-defined prompts tend to be sub-optimal and susceptible. Moreover, existing methods conduct ensembles either in boosting or in bagging individually, neglecting the potential benefits of combining the two worlds to enhance performance.

To alleviate the above issues, we advocate that a smarter paradigm for prompt ensemble in the era of LLMs is expected to be automatic, self-adaptive and joint-optimizable. Such paradigm reduces the need for manual effort and domain expertise, as well as takes prompt relations into consideration for directed optimization. Accordingly, we propose a simple, automatic and universal approach called PREFER (**PR**ompt **E**nsemble learning via **F**eedback-R**E**flect-**R**efine), towards a more effective prompt ensemble via utilizing the generative and reflective capabilities that LLMs excel at [madaan2023self]. As shown in Figure 1, our PREFER adopts a _feedback-reflect-refine_ circle for prompt boosting. Concretely speaking, inspired by the fact that weak learners pay more attention to hard examples via weight redistribution during boosting, we propose to transfer this hard-sample-oriented weighting into nature language feedback, which returns error information to the LLM for reflection. Hence, considering the reflection information, the LLM perceives the inadequacies of existing prompts and is able to generate new prompts to refine them purposefully. Attribute to the feedback-reflect-refine path, the LLM jointly optimizes the downstream tasks solving and prompt generation in an automatic manner. Iterating along this path, potential conflict and redundancy among prompts are reduced, which is vital for building a more stable and faster learner.

Furthermore, to adequately unleash the ability of each prompt and further enhance the stability during boosting, we propose a bilateral bagging approach, which incorporates forward and backward thinking for multi-source verification. Specifically, drawing inspiration from human decision-making, wherein uncertain answers are often resolved through a process of elimination, we instruct the LLM to compute a confidence score for each response and subsequently filter out the most uncertain answers. Given the observed tendency of LLMs to overestimate confidence in their predictions [zhao2021calibrate], our bilateral bagging approach assesses the responses from both forward and backward directions, in which the overconfidence bias can be counteracted subtly. The empirical results demonstrate the superiority of our bilateral bagging approach compared to other regular methods such as majority voting in both effectiveness and efficiency.

We conduct extensive experiments and in-depth case studies on a number of tasks, including reasoning, topic classification, hate speech discrimination, etc. The empirical results testify the effectiveness of our PREFER approach. Moreover, PREFER shows superiority in both stability and efficiency compared to existing approaches.

# Related Work

Our work is conceptually related to several subareas of artificial intelligent, including Large Language Models (LLMs), prompt engineering, and prompt ensemble learning. In this section, we briefly review the works in each subarea.

## Large Language Models

Nowadays, Large Language Models (LLMs) have made revolutionary progress and posed significant impact on various artificial intelligent community [zhao2023survey; ouyang2022training]. According to the scale law, LLMs demonstrate unprecedent power (called emergent abilities) with the rapid growth of model parameters and data volume [wei2022emergent]. For instance, the most prominent applications including ChatGPT and GPT-4 [gpt4] have shown surprising reasoning ability, human-like conversation skills, as well as a rich reserve of factual commonsense. Based on the surprising emergent abilities, a series of classical algorithms can evolve to a more intelligent version. In this paper, we provide a pilot work on ensemble algorithm as a preliminary study. We believe that our proposed approach could not only simply serve as a strong baseline to foster future research on prompt ensemble, but also shed light on the potential research direction towards improving classical algorithms with the power of LLMs.

[IMAGE: The pipeline of PREFER. Given the initial prompt p_0, LLM partially solves the problem via incorporating backward thinking. Then the error information will be used for prompt optimization through the feedback-reflect-refine process. Iterating this process and finally ensembling prompts based on evolved weights.]

## Prompt Engineering

In order to invoke the power of LLMs, a series of approaches have been proposed in the community, including parameter-efficient fine-tuning [hu2021lora; liu2021gpt] and prompt engineering [qiao2022reasoning; liu2023pre], etc. Due to the heavy weight of LLMs, fully or even partly fine-tuning them is expensive and inefficient. Accordingly, as an out-of-the-box paradigm, prompt engineering (aka prompting) has emerged as a new approach for adapting pretrain-prompt-predict path for downstream tasks. Tremendous cutting-edge effort has been made towards this area to improve the performance of prompting. Concretely, prompting adopts natural language as additional inputs, acting as instructions or hints to LLMs. For example, GPT2 [radford2019language] allows for unsupervised learning of LLM on multiple tasks through handcrafted task-specific prompts. However, building prompts manually can be expensive, biased and sub-optimal [liu2023pre]. Another line of works are devoted to conducting prompting in an automatic way. STaR [zelikman2022star] utilizes a simple loop to bootstrap LLMs with a self-taught manner, in which Chain-of-Thought (CoT) [wei2022chain] rationale is iteratively generated to hint the question answering process. Closer to our work, APO [pryzant2023automatic] iteratively optimizes the single prompt in a feedback manner, which treats the textual reflection information as gradient in classical deep learning.

## Prompt Ensemble Learning

Prior studies have proven that LLMs have multiple reasoning paths for a single problem, which could lead to distinct outputs from identical inputs [wang2022self]. To this end, prompt ensemble learning has been presented as a solution, which combines several individual prompts to obtain better stability and generalization performance. Boosting and bagging are two typical ensemble methods widely adopted in numerous classical tasks, while their adaptation on LLMs is still in its infancy. Current works for prompt boosting typically utilize a two-stage paradigm. PromptBoosting [hou2023promptboosting] has done a preliminary trial on this way, which conducts the traditional AdaBoost [freund1997decision] algorithm over a pre-defined prompt set for text classification. On the other hand, existing prompt bagging approaches mainly rely on regular majority voting, which can be computationally intensive. Notably, BPE [pitis2023boosted] focuses on constructing few-shot CoT prompts based on self-consistency [wang2022self], which offers better performance than a single prompt in the case of introducing exponentially additional computation. In this paper, we propose a computation-efficiency prompt bagging approach inspired by the human ethology, which incorporates prompt boosting for further performance improvement.

# Our PREFER Approach

## Preliminaries

In this section, we introduce preliminaries of our PREFER approach, including the problem formulation and the dismantling of key components.

Considering a reasoning or classification task driven by LLMs, given the training data `latex $\mathcal{D}_{tr}=\bigcup_{i}\{(x_i,y_i)\}$ `, the goal of the proposed PREFER is to automatically construct a prompt set `latex $\mathcal{P}=\bigcup_t\{p_t\}$ ` along with prompt weights `latex $\bigcup_t\{\lambda_t\}$ ` via LLM-augmented ensemble learning, which can then be utilized cooperatively for the subsequent inference. Here `latex $x_i\in\mathcal{X}$ ` denotes the input texts and `latex $y_i\in{\mathcal{Y}}$ ` denotes the output label. It is noted that an initial prompt `latex $p_0$ ` is provided as the seed for the subsequent iteration. Instead of requiring any supervised fine-tuning (SFT) or reinforcement learning, our proposed PREFER utilizes out-of-box LLM API (e.g., ChatGPT or GPT-4) as the foundation model `latex $\mathcal{M}$ ` for universality and flexibility. As illustrated in Figure 2, our PREFER mainly contains two components, i.e. feedback-driven prompt boosting and bilateral prompt bagging, which will be elaborated in sections below.

## Prompt Boosting via Feedback-Reflect-Refine

Before delving into the technical details of the proposed prompt boosting approach, we first provide our design principle, based on the thinking about what characteristics should an intelligent prompt boosting have in the era of LLMs. Review that boosting algorithms combine several individual weak learners to obtain better generalization performance. Considering the fact that weaker learners are supposed to pay more attention to hard samples during boosting, we advocate that an intelligent boosting algorithm is expected to understand what problems the previous weak learners cannot solve. That is, instead of building prompts individually, the relation among prompts should be considered for better performance and faster convergence. In another vein, to reduce the manual effort, the prompt boosting process should be automatic, where each prompt can be constructed without manual intervention. Furthermore, the prompt boosting should be universal and adaptive, for empowering any prompting-based task with the superiority of ensemble learning seamlessly.

Our proposed PREFER embraces all the above design principles, towards a simple, automatic and adaptive prompt ensemble paradigm. Inspired by the classical boosting algorithm such as AdaBoost [freund1997decision] and iterative prompting algorithms [pryzant2023automatic], we adopt an iterative manner to build the prompt set where each prompt is treated as a weak learner. As illustrated in Figure 2, acting as a weak learner, each prompt can only handle part of the instance space, where new prompts will be added to expand the solving space by introducing more information. Based on the error-ambiguity decomposition of ensemble learning [opitz1995generating], the ensemble error mathematically contains two parts:

```latex
$$E_{ensemble}=\bar{E}-\bar{A}$$
```

where `latex $\bar{E}$ ` and `latex $\bar{A}$ ` respectively denote the average error and the average ambiguity (also called diversity) of individual weak learners. Based on this equation, the ensemble performance is positively correlated with both the accuracy and diversity of weak learners. Considering this requirement, the prompt in each iteration is supposed to focus on the hard examples that the prompts in previous iterations cannot handle. Inspired by the way human reflect and refine for improving performance when tackling difficult tasks, we propose a feedback-reflect-refine pipeline, asking the LLM to consider the relation of prompts in the iteration, generate new informative prompts, and optimize them jointly.

**Example Solving Prompt Template:**

```
# Task
Given two sentences, determine whether
sentence 2 provides an answer to the
question posed by sentence 1.

# Output format
Explain your reasoning process in one
sentence and Answer "Yes" or "No" as the
label.

# Prediction
Sentence 1: {text1}
Sentence 2: {text2}
Label:[]
```

**Example Feedback Prompt Template:**

```
I'm trying to write a Textual Entailment
task prompt. My current prompt is: {prompt}
But this prompt gets the following examples
wrong: {error_info}

Give {num_feedbacks} reasons why the prompt
could have gotten these examples wrong. Wrap
each reason with <START> and <END>.
```

Concretely speaking, we define two types of prompt templates, namely the `solving prompt` and the `feedback prompt`, which are respectively responsible for solving downstream tasks and conducting the feedback process. Following In-Context Learning (ICL) [dai2022can], we format both types of prompts with the component of the instruction, demonstration and output format. Given the initial seed prompt `latex $p_0$ ` and the corresponding performance, we build the feedback prompt based on the feedback template and the wrong examples. This is reminiscent of the gradient in deep learning optimization, which indicates the direction of model optimization, the key difference lies that the feedback form changes from numerical into textual. The feedback prompt will then be fed to the LLM `latex $\mathcal{M}$ ` for self-reflecting, and `latex $\mathcal{M}$ ` provides a series of reasons why the current prompt `latex $p_t$ ` can solve some examples well but not others. Based on the reflection, the LLM is asked to generate new prompts in connection with hard examples specified in the previous iteration. In detail, the sampled wrong examples and corresponding textual labels are combined to `error_info` in the feedback prompt template. Mathematically, this feedback-reflect-refine process can be formulated via the Bayesian theory:

```latex
$$\mathcal{P}(p_t|\mathcal{X},\mathcal{Y},p_{t-1})=\mathcal{P}(\mathcal{R}_t|\mathcal{X},\mathcal{Y},p_{t-1})\cdot\mathcal{P}(p_t|\mathcal{R}_t)$$
```

here `latex $\mathcal{R}_t$ ` denotes the reflection of the LLM `latex $\mathcal{M}$ ` at the t-th iteration. It is noted that our PREFER only modifies the instruction of the `solving prompt`, while other parts remain unchanged.

Close to our work, APO [pryzant2023automatic] also conducts a feedback-based mechanism for prompt optimization. Nevertheless, there are several intrinsic differences between such iterative prompting approach and our PREFER. First, APO aims to search for a single prompt covering the largest possible solution space, while our PREFER organizes a set of prompts via ensemble learning, which works in tandem to cover multiple sub-spaces. Second, our PREFER proposes an effective bagging approach to reduce the variance of the LLM, which is superior to the regular techniques such as beam search or Monte Carlo search in APO. Experimental results demonstrate that our PREFER outperforms APO by a quite large margin with less computational cost and higher stability.

## Bilateral Prompt Bagging

As shown in the ensemble error equation, the quality and stability of weak learners is essential to the ensemble performance. Due to the generative property of language model, LLMs' outputs are highly sensitive to the input prompts, which affects the stability of both the feedback and weight calculation process. To alleviate this issue, direct solutions include majority voting or beam search, which is commonly used in the community [wang2022self; li2023making]. However, these methods are computationally intensive, especially for LLMs with massive parameters. Accordingly, to enhance the ability and stability of each prompt with limited calculation burden, we further propose a bagging approach called _bilateral prompt bagging_, which draws inspiration from human behavior of utilizing forward and backward thinking for tackling difficult tasks.

**Algorithm: PREFER**

**Input**: Training data `latex $\mathcal{D}_{tr}=\bigcup_{i}\{(x_i,y_i)\}$ `, the LLM `latex $\mathcal{M}$ `, the seed prompt `latex $p_0$ `, the prompt templates `latex $\mathcal{T}_{\tt solving}$ ` and `latex $\mathcal{T}_{\tt feedback}$ `

**Output**: the result prompt set `latex $\mathcal{P}=\bigcup_t\{p_t\}$ ` and their weights `latex $\bigcup_t\{\lambda_t\}$ `, the reflection set `latex $\bigcup_t\{\mathcal{R}_t\}$ `

1. Set the initial data weight to `latex $\omega_i^{(0)}=1/|\mathcal{D}_{tr}|,\forall{i}\in\{0,\cdots,|\mathcal{D}_{tr}|\}$ `, `latex $\mathcal{P}=\{p_0\}$ `
2. For each iteration:
   - Generate new `latex $p_t$ ` with {`latex $\mathcal{M}$ `, reflection `latex $\mathcal{R}_{t-1}$ `}
   - Solve target tasks with {`latex $p_t$ `, `latex $\mathcal{T}_{\tt solving}$ `, `latex $\omega_i$ `}
   - Conduct bilateral bagging
   - Build `feedback prompt` with {`error_info`, `latex $\mathcal{T}_{\tt feedback}$ `}
   - Perform feedback and get the reflection `latex $\mathcal{R}_{t}$ `
   - Compute weighted error
   - Update the weight on `latex $p_t$ `
   - Update the instance weights in `latex $\mathcal{D}_{tr}$ ` followed by re-normalization
   - `latex $\mathcal{P}=\mathcal{P}\cup{p_t}$ `, `latex $\mathcal{R}=\mathcal{R}\cup{\mathcal{R}_t}$ `
3. Return `latex $\bigcup_t\{p_t\}$ `, `latex $\bigcup_t\{\lambda_t\}$ `, `latex $\bigcup_t\{\mathcal{R}_t\}$ `

Concretely speaking, humans commonly adopt the process of elimination when they are not sure about the decision making. Inspired by this, we advocate that similar spirits can be utilized in the prompt bagging. In each iteration, the LLM `latex $\mathcal{M}$ ` is required to evaluate its answer's confidence by utilizing the generated prompt `latex $p_t$ ` followed by a confidence evaluation clause. When the evaluation result is not confident enough, the reverse thinking takes effect via conducting elimination process. In detail, we consider the quantitative confidence score evaluation in both forward and backward thinking. Take the classification task as an example, in the forward evaluation, `latex $\mathcal{M}$ ` is required to measure the confidence that each candidate answer is the correct one. As for the backward evaluation, `latex $\mathcal{M}$ ` is required reversely to measure the confidence that each candidate answer is excluded. For notational simplicity, we name the confidence scores corresponding to the forward and backward evaluations with `latex $S^{+}$ ` and `latex $S^{-}$ ` respectively. After these, the final probability can be calculated via combining `latex $S^{+}$ ` and `latex $S^{-}$ ` with a subtractive fashion:

```latex
$$\hat{y}={\arg\max}_j{\frac{e^{S^{+}_j-S^{-}_j}}{\sum_c^{K}{e^{S^{+}_c-S^{-}_c}}}}$$
```

here `latex $\hat{y}$ ` denotes the predicted answer, c and j denote the indexes of candidate answers. It is noted that LLMs tend to evaluate confidence score overconfidently [zhao2021calibrate], while our proposal ingeniously circumvents this inadequacy via positive and negative offsets. We believe that such paradigm can also shed light on the community of LLMs' calibration [zhao2023automatic].

Attributed to the introduction of reverse thinking mechanism, the accuracy-versus-efficiency dilemma can be largely alleviated for prompt bagging. Experimental results explicitly manifest that such bilateral bagging outperforms regular methods (e.g., majority voting) in both effectiveness and efficiency.

### Overall Algorithm

To sum up, we conclude the proposed PREFER in the algorithm above. Basically, our PREFER follows the pipeline of the classical AdaBoost [freund1997decision] algorithm, while enhancing it with the _feedback-reflect-refine boosting_ and the _bilateral prompt bagging_. Both branches can co-adapt and cooperate for automatic prompt set optimization. In detail, the weighted ensemble error in the t-th iteration is calculated as:

```latex
$$error^{(t)}=\sum_{i=1}^{|\mathcal{D}_{tr}|}\frac{\omega_i^{(t)}\cdot\mathbb{I}\big(y_i\neq \mathcal{M}(p_t,x_i)\big)}{\sum_i^{|\mathcal{D}_{tr}|}\omega_i}$$
```

here `latex $\mathbb{I}$ ` is the identify function. Moreover, the weight in each iteration is updated based on the above error information as:

```latex
$$\lambda^{(t)}=\log\frac{1-error^{(t)}}{error^{(t)}}+\log\big(|\mathcal{Y}|-1\big)$$
```

Finally, the instance weights in training dataset `latex $\mathcal{D}_{tr}$ ` can be updated by:

```latex
$$\omega^{(t)}_i=\omega^{(t-1)}_i\cdot\exp\Big(\lambda^{(t)}\cdot\mathbb{I}\big(y_i\neq \mathcal{M}(p_t,x_i)\big)\Big)$$
```

here `latex $\forall{i}\in\{0,\cdots,|\mathcal{D}_{tr}|\}$ ` is the index of training examples. Once the process of the algorithm is complete, optimized prompts `latex $\bigcup_t\{p_t\}$ ` along with their weights `latex $\bigcup_t\{\lambda_t\}$ ` can be obtained, which can then be utilized for application via weighted decision making. Moreover, the intermediate reflection `latex $\bigcup_t\{\mathcal{R}_t\}$ ` naturally provides abundant interpretability for prompt boosting.

# Experiments

## Experimental Settings

### Datasets

We conduct experiments on a wide range of tasks including natural language inference and classification:

- **Natural Language Inference**
  - _SNLI_ [bowman2015large], _MNLI_ [williams2017broad], and _RTE_ [dagan2005pascal]: textual entailment inference
  - _QNLI_ [rajpurkar2016squad]: question-answering inference

- **Natural Language Classification**
  - _Ethos_ [mollas2020ethos]: hate speech detection
  - _Liar_ [wang2017liar]: fake news classification
  - _ArSarcasm_ [farha2020arabic]: Arabic sarcasm detection

### Compared Baselines

To manifest the superiority of our PREFER approach, we compare it with several state-of-the-art baselines. As the closest work to our proposal, PromptBoosting [hou2023promptboosting] conducts the traditional AdaBoost algorithm over a pre-defined prompt set for text classification. As a remarkable work of iterative prompting methods, APO [pryzant2023automatic] utilizes an iterative manner for optimizing a single prompt, where the performance of the previous prompt will be used to form a natural language "gradient" that guides the prompt optimization. Moreover, we also conduct single-prompt and Chain-of-Thought (CoT) enhanced single-prompt experiments, to figure out the superiority of our PREFER compared with vanilla and optimized non-iterative prompting works. Lastly, we compare a variant of our PREFER, which rewrites synonymous prompts for boosting instead of feedback-reflect-refine paradigm, for ascertaining the utility of LLMs' reflective ability.

### Running settings

To make a fair comparison, we closely follow the experimental protocols that were set up in APO with our own data split. In detail, we mainly conduct developing and evaluation of our PREFER in few-shot settings. For each task, we randomly sample k examples from the original training dataset, to build k-shot training set `latex $\mathcal{D}_{tr}$ `. By default, the k in this paper is set to 50. We use F1-score for performance evaluation.

## Experimental Results

In view of the key proposals in our PREFER approach, we are naturally motivated to ask the following interesting research questions.

- **RQ1**. Is the prompt ensemble learning really useful for improving LLMs' performance?
- **RQ2**. Are the feedback-driven boosting and bilateral bagging mechanism both useful for prompt synthesis in ensemble learning?
- **RQ3**. Is the reason why our proposal is superior to the iterative approaches due to the expansion of the sample space?

To figure out the answers to these questions, we conduct sufficient experiments and the experimental results can be found in the main results table.

**Main Results Table:**

| Datasets            | SNLI      | MNLI      | QNLI      | RTE       | Ethos     | Liar      | ArSarcasm |
| ------------------- | --------- | --------- | --------- | --------- | --------- | --------- | --------- |
| Single Prompt       | 0.587     | 0.660     | 0.660     | 0.720     | 0.833     | 0.535     | 0.511     |
| Single Prompt (CoT) | 0.575     | 0.685     | 0.660     | 0.731     | 0.804     | 0.549     | 0.525     |
| Synonym Ensemble    | 0.580     | 0.746     | 0.720     | 0.659     | 0.812     | 0.572     | 0.569     |
| PromptBoosting      | 0.619     | 0.574     | 0.631     | 0.673     | -         | -         | -         |
| APO                 | -         | -         | -         | -         | 0.964     | 0.663     | 0.873     |
| APO\*               | -         | -         | -         | -         | 0.947     | 0.658     | 0.639     |
| **Ours**            | **0.647** | **0.767** | **0.793** | **0.753** | **0.963** | **0.744** | **0.739** |

For the first question, we compare the ensemble-based approaches (including PromptBoosting and our PREFER) with the single-prompt-based approaches. As shown in the experimental results, when compared to the vanilla (Line 1) and CoT-enhanced single prompt approach (Line 2), both PromptBoosting and our PREFER outperform them by a significant margin. For example, our PREFER outperforms the second best approach by up to 6.3% for the _QNLI_ dataset, and 13.1% for the _Liar_ dataset. The general trend that becomes apparent from the results is that the more difficult the task is, the better ensemble learning performs. We conjecture that it is due to the feedback-reflect-refine paradigm can achieve greater improvement for the harder tasks, while the marginal gain of this mechanism would be diminishing for easier tasks. It is noted that the experimental results change marginally by adding Chain-of-Thought (CoT) for single-prompt approach.

To explore the second research question, we compare our PREFER with both the two-stage ensemble approach PromptBoosting (Line 4) and the synonym rewriting ensemble approach (Line 3). For PromptBoosting, we use the publicly available code and conduct experiments following its hyperparameter setting. For the synonym rewriting ensemble, we conduct prompt rewriting operation with same semantics, followed by regular ensemble learning similar to our PREFER. Our approach consistently outperforms the two ensemble approaches by a significant margin, reaching around 5% to 35% relative improvement in most datasets. We attribute the superiority of PREFER to its feedback-reflect-refine mechanism as well as the design of the joint optimization paradigm that naturally captures relations among weak learners.

As for the third question, APO [pryzant2023automatic] is introduced as the remarkable approach of iterative prompting for comparison. It is noted that we reproduce the APO approach (APO\* at Line 6) for a strictly fair comparison, which eliminates the interference from data sampling. Similar performance trends are observed in this comparison, that is, our PREFER outperforms APO with the power of feedback-reflect-refine boosting and bilateral prompt bagging. It manifests that through expanding the sample space in a nonlinear way, prompting performance can be enhanced significantly than single-prompt methods with similar iteration rounds. In fact, attributed to our bagging design, our PREFER is superior to APO not only in effectiveness, but also in stability and efficiency.

## Ablation Study

[IMAGE: Training process comparison for APO and ours.]

**Ablation Study Results:**

| Method  | -Feedback    | -Bagging     | Voting       | Ours  |
| ------- | ------------ | ------------ | ------------ | ----- |
| SNLI    | 0.580 (drop) | 0.640        | 0.626        | 0.647 |
| MNLI    | 0.746        | 0.713        | 0.733        | 0.767 |
| QNLI    | 0.720        | 0.747        | 0.767        | 0.793 |
| RTE     | 0.659 (drop) | 0.740        | 0.760        | 0.753 |
| Ethos   | 0.812 (drop) | 0.947        | 0.938        | 0.963 |
| Liar    | 0.572 (drop) | 0.718        | 0.701        | 0.744 |
| Sarcasm | 0.572 (drop) | 0.653 (drop) | 0.649 (drop) | 0.739 |

Note: "(drop)" indicates a severe performance drop (more than 10%).

To figure out the effectiveness of each component in our proposal, we perform ablations on both feedback-reflect-refine boosting and bilateral bagging. First, we remove the feedback mechanism in prompt boosting ("-Feedback"), in which the initial seed prompt is just modified by the LLM without directed optimization, then the similar boosting and bagging strategy is performed to align the settings of our PREFER. It is observed that the prompt ensemble without feedback-reflect-refine path is sub-optimal, signifying that such feedback mechanism plays an important role for directed prompt boosting. Second, to figure out the effectiveness of our bilateral bagging component, we also turn off the whole component ("-Bagging") or replace it with majority voting ("Voting"). The experimental results convey that our bilateral bagging is beneficial for PREFER, and distinctly outperform the regular bagging approach of majority voting. Notably, the performance of majority voting is basically satisfactory, manifesting that the prompt bagging can benefit the boosting prompt process consistently. An interesting phenomenon is that removing the feedback-reflect-refine module leads to more serious performance decline than removing the bagging module. This is expected, since the bagging mainly benefits the stability for each prompt, while the boosting is more important for prompt ensemble.

## Training Efficiency

To further demonstrate the superiority of our method, we conduct detailed experiments on the _Ethos_ dataset for training efficiency, including training time and convergence speed. Both APO and our PREFER reach the peak at optimization step 2 to 3, which indicates that neither approaches require extensive iterations to achieve impressive results. Clearly, our PREFER has a more stable performance retention compared to APO during subsequent iterations. On the other hand, considering the limitations on the speed and frequency of LLM API accesses, we compare the number of API accesses during training and the time consumption for the first two prompt optimization steps. It can be observed that the access number of APO increases rapidly during beam search and bandit selection, which brings serious efficiency problems. On the contrary, our PREFER does not enforce optimal optimization at each time step, but rather maintains a stable and efficient improvement via ensemble learning.

## Case Study

[IMAGE: Comparison of the generation obtained from our feedback-reflect-refine paradigm and synonymous rewrite.]

To visualize our feedback-reflect-refine paradigm, we provided a case study as an illustration. Taking the nature language inference task on the _QNLI_ dataset as an example, we provide the intermediate output of the LLM in the feedback-reflect-refine process, to show its effectiveness and interpretability. Compared to the prompt generated by synonymous rewriting, the one generated by our method is more informative and logically compensates for the deficiencies of the previous prompt, thus achieving directed prompt optimization.

# Conclusion

In this paper, we propose a simple, automatic, and universal prompt ensemble approach called PREFER (**PR**ompt **E**nsemble learning via **F**eedback-R**E**flect-**R**efine), empirically showing consistent and significant improvement over previous baselines. PREFER contains two main components, including feedback-reflect-refine prompt boosting and bilateral prompt bagging. Prompt boosting branch directly and collectively optimizes prompt in an automatic fashion based on the evolving self-reflection. Prompt bagging proposes a bagging paradigm containing forward and backward cooperation inspired by human behavior, which adequately unearths the real quality of each generated prompt and thus ensures the stability of both the feedback-reflect-refine process and weight calculation in boosting. In a parallel note, our PREFER brings the prompt ensemble approach with more interpretability by harnessing the LLMs' language ability. For future work, two interesting questions worth studying, namely 1) how to further reduce the calculation of prompt ensemble to approach single-prompt colleagues, and 2) how to make more classical algorithm more intelligent based on the power of LLMs.
